/*
 * Decompiled with CFR 0.152.
 */
package tech.sethi.pebbles.crates.lootcrates;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.sethi.pebbles.crates.lootcrates.CrateConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\r\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Ltech/sethi/pebbles/crates/lootcrates/CrateConfigManager;", "", "<init>", "()V", "", "createCratesFolder", "", "crateName", "Ltech/sethi/pebbles/crates/lootcrates/CrateConfig;", "getCrateConfig", "(Ljava/lang/String;)Ltech/sethi/pebbles/crates/lootcrates/CrateConfig;", "", "updatedCrateConfigs", "saveCrateConfigs", "(Ljava/util/List;)V", "crateConfig", "setCrateConfig", "(Ljava/lang/String;Ltech/sethi/pebbles/crates/lootcrates/CrateConfig;)V", "", "loadCrateConfigs", "()Ljava/util/List;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "Ljava/io/File;", "configDirectory", "Ljava/io/File;", "", "crateConfigs", "Ljava/util/Map;", "pebbles-crates"})
@SourceDebugExtension(value={"SMAP\nCrateConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrateConfigManager.kt\ntech/sethi/pebbles/crates/lootcrates/CrateConfigManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,90:1\n1863#2,2:91\n13409#3,2:93\n*S KotlinDebug\n*F\n+ 1 CrateConfigManager.kt\ntech/sethi/pebbles/crates/lootcrates/CrateConfigManager\n*L\n31#1:91,2\n53#1:93,2\n*E\n"})
public final class CrateConfigManager {
    @NotNull
    public static final CrateConfigManager INSTANCE = new CrateConfigManager();
    @NotNull
    private static final Gson gson;
    @NotNull
    private static final File configDirectory;
    @NotNull
    private static final Map<String, CrateConfig> crateConfigs;

    private CrateConfigManager() {
    }

    public final void createCratesFolder() {
        if (!configDirectory.exists()) {
            configDirectory.mkdirs();
        }
    }

    @Nullable
    public final CrateConfig getCrateConfig(@NotNull String crateName) {
        Intrinsics.checkNotNullParameter((Object)crateName, (String)"crateName");
        return crateConfigs.get(crateName);
    }

    public final void saveCrateConfigs(@NotNull List<CrateConfig> updatedCrateConfigs) {
        Intrinsics.checkNotNullParameter(updatedCrateConfigs, (String)"updatedCrateConfigs");
        crateConfigs.clear();
        Iterable $this$forEach$iv = updatedCrateConfigs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CrateConfig crateConfig = (CrateConfig)element$iv;
            boolean bl = false;
            String crateName = crateConfig.getCrateName();
            crateConfigs.put(crateName, crateConfig);
            File file = new File(configDirectory, crateName + ".json");
            String string = gson.toJson((Object)crateConfig);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        }
    }

    public final void setCrateConfig(@NotNull String crateName, @NotNull CrateConfig crateConfig) {
        Intrinsics.checkNotNullParameter((Object)crateName, (String)"crateName");
        Intrinsics.checkNotNullParameter((Object)crateConfig, (String)"crateConfig");
        crateConfigs.put(crateName, crateConfig);
        this.saveCrateConfigs(CollectionsKt.toList((Iterable)crateConfigs.values()));
    }

    @NotNull
    public final List<CrateConfig> loadCrateConfigs() {
        List loadedConfigs;
        block2: {
            if (!configDirectory.exists()) {
                configDirectory.mkdirs();
            }
            loadedConfigs = new ArrayList();
            crateConfigs.clear();
            File[] fileArray = configDirectory.listFiles(CrateConfigManager::loadCrateConfigs$lambda$1);
            if (fileArray == null) break block2;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)file);
                String json = FilesKt.readText$default((File)file, null, (int)1, null);
                if (!(((CharSequence)json).length() > 0)) continue;
                CrateConfig crateConfig = (CrateConfig)gson.fromJson(json, CrateConfig.class);
                String crateName = crateConfig.getCrateName();
                crateConfigs.put(crateName, crateConfig);
                Intrinsics.checkNotNull((Object)crateConfig);
                loadedConfigs.add(crateConfig);
            }
        }
        return loadedConfigs;
    }

    private static final boolean loadCrateConfigs$lambda$1(File file, String name) {
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.endsWith$default((String)name, (String)".json", (boolean)false, (int)2, null);
    }

    static {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)class_1799.class), (Object)new ItemStackTypeAdapter()).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        CrateConfigManager.gson = gson;
        configDirectory = new File("config/pebbles-crate/crates");
        crateConfigs = new LinkedHashMap();
        INSTANCE.loadCrateConfigs();
    }
}

